import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;

public class WebhookHandler {

    public static void main(String[] args) throws IOException {
        int port = 8080; // Specify the port where the server will listen

        HttpServer server = HttpServer.create(new java.net.InetSocketAddress(port), 0);
        server.createContext("/webhook", new WebhookRequestHandler());
        server.setExecutor(null); // Use the default executor
        server.start();
    }

    static class WebhookRequestHandler implements HttpHandler {
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("POST".equals(exchange.getRequestMethod())) {
                InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), "UTF-8");
                BufferedReader br = new BufferedReader(isr);

                String inputLine;
                StringBuilder requestBody = new StringBuilder();
                while ((inputLine = br.readLine()) != null) {
                    requestBody.append(inputLine);
                }

                // Parse the data from the POST request
                String[] params = requestBody.toString().split("&");
                String status = "";
                String orderId = "";
                String remark1 = "";

                for (String param : params) {
                    String[] keyValue = param.split("=");
                    if (keyValue.length == 2) {
                        String key = keyValue[0];
                        String value = keyValue[1];
                        if ("status".equals(key)) {
                            status = value;
                        } else if ("order_id".equals(key)) {
                            orderId = value;
                        } else if ("remark1".equals(key)) {
                            remark1 = value;
                        }
                    }
                }

                // Check if the status is "SUCCESS"
                if ("SUCCESS".equals(status)) {
                    // Process the data here as needed
                    // For example, log it or perform other actions

                    // Respond to the webhook with a success message
                    String response = "Webhook received successfully";
                    exchange.sendResponseHeaders(200, response.length());
                    try (OutputStream os = exchange.getResponseBody()) {
                        os.write(response.getBytes());
                    }
                } else {
                    // Respond with an error message if the status is not "SUCCESS"
                    String response = "Invalid status: " + status;
                    exchange.sendResponseHeaders(400, response.length());
                    try (OutputStream os = exchange.getResponseBody()) {
                        os.write(response.getBytes());
                    }
                }
            } else {
                // Invalid request method
                exchange.sendResponseHeaders(400, 0);
            }
            exchange.close();
        }
    }
}
