<?php
header("Content-Type: application/json"); // Set response type to JSON

include('../Internal/php/qrlib.php'); // Include phpqrcode library

// Read JSON input
$inputJSON = file_get_contents("php://input");
$input = json_decode($inputJSON, true);

// Validate input
if (!isset($input['data']) || empty($input['data'])) {
    echo json_encode(['error' => 'Missing required parameter: data']);
    exit;
}

$data = $input['data']; // UPI or Paytm payment URL
$ecc = $input['ecc'] ?? 'M'; // Error correction level (default: M)
$size = $input['size'] ?? 8;  // QR size (default: 8)

// Generate QR code
ob_start();
QRcode::png($data, null, constant('QR_ECLEVEL_' . strtoupper($ecc)), $size);
$imageData = ob_get_contents();
ob_end_clean();

// Convert image to base64
$base64QRCode = 'data:image/png;base64,' . base64_encode($imageData);

// Return JSON response
echo json_encode(['qr_code' => $base64QRCode]);
?>